///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

function ComplexFilterEditor(editorID, sSelectedText)
{
   this.eid = editorID;
   this.form = document.forms[editorID + 'Form'];

   // filter editor should display counts when asked to
   var tFilterEditor = new FilterEditor('idFilter', null, this.eid);
   tFilterEditor.displayFilterCounts = false;
   tFilterEditor.bAllowEditFormula = false;
   tFilterEditor.bSegmentSimpleSelectionRulesEditor = true;
   this.filterPanel = new XUIInline('idFilter', tFilterEditor, this);

   // set the menu attributes for the Filter Editor menus to compensate for scroll
   {
      var tFilterItemMenu = document.getElementById('idFilterItemMenu');
      if (null != tFilterItemMenu)
         tFilterItemMenu.popupScrollContainer = this.eid + "ScrollableDiv";

      var tFilterGroupMenu = document.getElementById('idFilterGroupMenu');
      if (null != tFilterGroupMenu)
         tFilterGroupMenu.popupScrollContainer = this.eid + "ScrollableDiv";
   }

   var sDescription = kmsgComplexFilterDescriptionReplace;
   if (sSelectedText == null || sSelectedText.length == 0)
   {
      sDescription = kmsgComplexFilterDescriptionInsert;
      sSelectedText = "expr";
   }
   document.getElementById(editorID + 'Description').innerHTML = sDescription;
   document.getElementById(editorID + 'Template').innerHTML = "<span dir='ltr'>" + kmsgComplexFilterExpressionTemplate.replace("%0", sSelectedText) + "</span>";
}

ComplexFilterEditor.prototype = new XUIEditor();

//-------------------
ComplexFilterEditor.prototype.load = function(xmlElement, xmlReportElement)
{
   XUICheckNodeName("ComplexFilterEditor.prototype.load", xmlElement, "saw:criteria");
   XUICheckNodeName("ComplexFilterEditor.prototype.load", xmlReportElement, "saw:report");

   this.originalElement = xmlElement;
   this.originalReportElement = xmlReportElement;

   this.element = this.originalElement.cloneNode (true); // criteria node being edited
   this.reportElement = this.originalReportElement.cloneNode (true); // the report node itself

   this.newFilterElement = null;

   this.originalFilterElement = this.element.selectSingleNode("saw:filter");
   if (null != this.originalFilterElement)
      this.element.removeChild(this.originalFilterElement);

   var tFilter = XUIAppendNewElement(this.element, saw.xml.kSawNamespace, 'filter');
   tFilter.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
   tFilter.setAttribute("xmlns:sawx", "com.siebel.analytics.web/expression/v1");

   this.filterPanel.editor.displayFilterCounts = false;
   this.filterPanel.load (this.element, this.reportElement);

   this.panel.div.style.maxWidth = 500 + "px";
}

//-------------------
ComplexFilterEditor.prototype.onChildApply = function()
{
}

//-------------------
ComplexFilterEditor.prototype.apply = function()
{
   this.filterPanel.apply();
   this.newFilterElement = this.element.selectSingleNode("saw:filter");
   return true;
}

//-------------------
ComplexFilterEditor.prototype.discard = function()
{
   if (XUIDialog.isVisible("idColumnFilter") == false
      && XUIDialog.isVisible('idSubQueryFilter') == false
      && XUIDialog.isVisible('idSqlFilter') == false)
   {
      this.parentEditor.discard();
   }
}

ComplexFilterEditor.prototype.insertColumn = function(tColumnDef)
{
   var tColumns = XUIForceSingleNode(this.element, saw.xml.kSawNamespace, "columns");
   var nCol = saw.getChildElementsLength(XUIColumnSpace.xmlElement);
   var sID = XUIGetUniqueColumnID(this.reportElement, nCol);
   var tInfo = XUIColumnSpace.addColumnInfo(tColumnDef, sID);
   var tNode = XUIAppendNewElement(tColumns, saw.xml.kSawNamespace, 'column');
   tNode.setAttribute("formula", tInfo.getAttribute("formula"));
   tNode.setAttribute("columnID", sID);

   this.filterPanel.editor.displayFilter ();
   this.filterPanel.editor.creatingNewFilterCriteria = true;
   this.filterPanel.editor.addFilterFromFormula(tColumnDef.GetSQLFormula());
   this.filterPanel.editor.displayFilter ();
}

